function [c, t] = WBC(db, c0, options)
% Compute WBC
% Input:
%  db -- a struct that stores n-phase discrete distribution data.
%           db{1...n} are data associated to different phases;
%           db{i}.stride is an array of the support sizes of individual
%           instance at phase i; 
%           db{i}.supp is a matrix storing all support points across
%           instances by colums at phase i;
%           db{i}.w is an array storing all weights across instances at
%           phase i; 
%           It is required that
%           length(db{i}.w)==size(db{i}.supp,2) = sum(db{i}.stride).
%  c0 -- a multi-phase discrete distribution as the initial start
%           c0.supp is a matrix storing support points by columns 
%           c0.w is an array of weights. It can be automatically generated
%           if it is set to [].
%
%  options --
%          shared:
%           options.support_size: the desired support size of barycenter
%
%           options.support_points: if specified, the support of barycenter
%           is fixed to options.support_points. Then it is required that
%           options.support_size == size(options.support_points, 2)
%
%           options.max_support_size: the maximum desired support size of
%           barycenter, typically set to 3*support_size(c).
%           
%
% Output:
%  c  -- WBC
%  OT -- matching matrix between c and each instance

fprintf('\n**********************************************\n')
resultfile = fopen('resultfile.txt','a+');

method='WBC';
if isfield(options, 'method')
    method = options.method;
end

n=length(db);
c=cell(n,1);
for s=1:n
    tic;
    if strcmp(method, 'WBC')
        [c{s}, iter, optval,t,fea]=centroid_WBC(db{s}.stride, db{s}.supp, db{s}.w, c0{s}, options);
        fprintf('Pre-specified WBC needs %5.2fs\n',t);
        fprintf(resultfile,'WBC, %d, %4.3f, %2.8f\n',iter, t, optval); 
    elseif strcmp(method, 'WB')
        [c{s}, iter, optval,t,fea]=centroid_WB(db{s}.stride, db{s}.supp, db{s}.w, c0{s}, options);
        fprintf('Pre-specified WB needs %5.2fs\n',t);
        fprintf(resultfile,'WB, %d, %4.3f, %2.8f\n',iter, t, optval);
    elseif strcmp(method, 'gurobi')
        [c{s}, optval,t,fea]=centroid_Gurobi(db{s}.stride, db{s}.supp, db{s}.w, c0{s}, options);
        fprintf('Default setting Gurobi needs %5.2fs\n',t);
        fprintf(resultfile,'gurobi, %4.3f, %2.8f\n', t, optval);
    end
    
    toc;
    fclose(resultfile);
end